(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      2629,         78]*)
(*NotebookOutlinePosition[      3309,        101]*)
(*  CellTagsIndexPosition[      3265,         97]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\(Sriemann[f_, a_, b_, n_] := 
        Module[{inc = N[\((b - a)\)/n]}, 
          Sum[f[a + 0.5*inc + k*inc], {k, 0, n - 1}]*inc];\)\)], "Input"],

Cell[BoxData[
    \(\(f[x_] = Cos[1/x]/x;\)\)], "Input"],

Cell[BoxData[
    \(Sriemann[f, 0.01, 1. , 40000] // Timing\)], "Input"],

Cell[BoxData[
    \(NIntegrate[Cos[1/x]/x, {x, 0.01, 1}]\)], "Input"],

Cell[BoxData[
    \(\(Sriemann[f_, a_, b_, c_, d_, n_, m_] := 
        Module[{incx = N[\((b - a)\)/n], incy = N[\((d - c)\)/m]}, 
          Sum[f[a + 0.5*incx + k*incx, c + 0.5*incy + j*incy], {k, 0, 
                n - 1}, {j, 0, m - 1}]*incx*incy];\)\)], "Input"],

Cell[BoxData[{
    \(g[x_, y_] = Cos[1/x*y]\), "\[IndentingNewLine]", 
    \(Sriemann[g, 0.01, 1, 0.01, 1, 200, 200] // Timing\)}], "Input"],

Cell[BoxData[
    \(NIntegrate[Cos[1/x*y], {x, 0.01, 1}, {y, 0.01, 1}]\)], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 166, 3, 50, "Input"],
Cell[1923, 56, 56, 1, 50, "Input"],
Cell[1982, 59, 72, 1, 50, "Input"],
Cell[2057, 62, 69, 1, 50, "Input"],
Cell[2129, 65, 267, 4, 70, "Input"],
Cell[2399, 71, 140, 2, 70, "Input"],
Cell[2542, 75, 83, 1, 50, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

